import java.io.*;
import java.math.BigInteger;
import java.util.StringTokenizer;

/**
 * Created by olymp on 12.11.2014.
 */
public class Template implements Runnable {

    class Rational {
        long numerator;
        long denominator;


        Rational(long numerator, long denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        Rational add(long dnumerator, long ddenominator) {
            numerator *= ddenominator / denominator;
            denominator = ddenominator;
            numerator += dnumerator;
            return this;
        }
    }

    private void solve() throws IOException {
        while (true) {
            String s = nextString();
            if(s.equals("#"))
                break;
            int pos = s.length() - 2;
            int zn = 1;
            Rational have = new Rational(0, 1);
            while (pos >= 0) {
                if(s.charAt(pos) == 's') {
                    have.add(90, zn);
                    pos -= 4;
                }
                else {
                    have.add(-90, zn);
                    pos -= 5;
                    if(have.numerator < 0)
                        have.numerator = 0;
                }
                zn *= 2;
            }
            long g = BigInteger.valueOf(have.numerator).gcd(BigInteger.valueOf(have.denominator)).longValue();
            out.print(have.numerator / g);
            if(have.denominator != g) {
                out.print("/" + (have.denominator / g));
            }
            out.println();
        }
    }











    BufferedReader br;
    StringTokenizer st;
    PrintWriter out;

    @Override
    public void run() {
        try {
            if(local) {
                br = new BufferedReader(new FileReader("input.txt"));
                out = new PrintWriter(System.out);
            }
            else {
                br = new BufferedReader(new InputStreamReader(System.in));
                out = new PrintWriter(System.out);
            }
            solve();
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }


    }


    public String nextString() throws IOException {
        while (st == null || !st.hasMoreTokens()) {
            st = new StringTokenizer(br.readLine());
        }
        return st.nextToken();
    }

    public int nextInt() throws IOException {
        return Integer.parseInt(nextString());
    }

    public double nextDouble() throws IOException {
        return Double.parseDouble(nextString());
    }

    public long nextLong() throws IOException {
        return Long.parseLong(nextString());
    }

    static boolean local;

    public static void main(String[] args) {
        local = args.length > 0 && args[0].equals("me");
        new Template().run();

    }


}
